jQuery(document).ready(function($) {

	$wrapper = $( '.posts' );
	if ( $wrapper.length ) {
		$grid = $wrapper.imagesLoaded( function() {
			$grid = $wrapper.masonry( {
				itemSelector: 		'.post-container',
				stagger: 			0,
				transitionDuration: 0,
			} );
		} );

		setTimeout( function() { $grid.masonry(); }, 500 );
		setTimeout( function() { $grid.masonry(); }, 1000 );
		setTimeout( function() { $grid.masonry(); }, 1500 );
		setTimeout( function() { $grid.masonry(); }, 2000 );
		setTimeout( function() { $grid.masonry(); }, 2500 );
	}

	// Toggle mobile-menu
	$(".nav-toggle").on("click", function(){	
		$(this).toggleClass("active");
		$(".mobile-navigation").slideToggle();
	});
	
	
	// Toggle search form
	$(".search-toggle").on("click", function() {	
		$(this).toggleClass("active");
		$(".header-search-block").slideToggle();
		if ( $( this ).hasClass( 'active' ) ) {
			$(".header-search-block .search-field").focus();
		} else {
			$(".header-search-block .search-field").blur();
		}
		return false;
	} );
	
	
	// Hide mobile-menu > 1000
	$(window).resize(function() {
		if ($(window).width() > 1000) {
			$(".nav-toggle").removeClass("active");
			$(".mobile-navigation").hide();
		}
	});


	// Display dropdown menus on focus.
	$( '.main-menu a' ).on( 'blur focus', function( e ) {
		$( this ).parents( 'li.menu-item-has-children' ).toggleClass( 'focus' );
	} );
	
	
	// Load Flexslider
    $(".flexslider").flexslider({
        animation: "slide",
        controlNav: false,
        prevText: "Previous",
        nextText: "Next",
        smoothHeight: true   
    });

        
	// resize videos after container
	var vidSelector = ".post iframe, .post object, .post video, .widget-content iframe, .widget-content object, .widget-content iframe";	
	var resizeVideo = function(sSel) {
		$( sSel ).each(function() {
			var $video = $(this),
				$container = $video.parent(),
				iTargetWidth = $container.width();

			if ( !$video.attr("data-origwidth") ) {
				$video.attr("data-origwidth", $video.attr("width"));
				$video.attr("data-origheight", $video.attr("height"));
			}

			var ratio = iTargetWidth / $video.attr("data-origwidth");

			$video.css("width", iTargetWidth + "px");
			$video.css("height", ( $video.attr("data-origheight") * ratio ) + "px");
		});
	};

	resizeVideo(vidSelector);

	$(window).resize(function() {
		resizeVideo(vidSelector);
	});
	
	
	// Smooth scroll to header
    $('.tothetop').click(function(){
		$('html,body').animate({scrollTop: 0}, 500);
		$(this).unbind("mouseenter mouseleave");
        return false;
    });
    
    
});